<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<!--Copyright (c) 2002-2003 Simon Woodside - http://www.simonwoodside.com-->
<!--This is open source software under the terms in LICENSE.txt-->

<!-- convert from weblog XML dialect into a brief summary to include on
     the front page (HTML format) -->

  <xsl:output 
    method = "xml"
    indent = "yes"
    /> 

  <xsl:include href="params.xsl"/>
  
  <xsl:template match="/">
    <page>
      <xhtml>
        <xsl:apply-templates/>
      </xhtml>
    </page>
  </xsl:template>

  <xsl:template match="entry">
    <div class="weblog_front_entry">
      <b><xsl:value-of select="date"/> - </b>
      <xsl:if test="title">
        <b>
              <xsl:value-of select="title"/>
        </b>
      </xsl:if>
      <xsl:apply-templates select="content"/>
      <a><xsl:attribute name="href"><xsl:value-of select="$weblog.archive.path"/>
          <xsl:text>/#</xsl:text><xsl:value-of select="date"/>
        </xsl:attribute>
        <xsl:text>Read More...</xsl:text>
      </a>
    </div>
  </xsl:template>
  
  <xsl:template match="content">
    <xsl:value-of select="substring(string(.),1,50)"/>
    <xsl:text>... </xsl:text>
  </xsl:template>
  
</xsl:stylesheet>
