<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<!--Copyright (c) 2002-2003 Simon Woodside - http://www.simonwoodside.com-->
<!--This is open source software under the terms in LICENSE.txt-->

<!-- convert from weblog XML dialect into HTML (actually XHTML) -->

  <xsl:output 
    method = "xml"
    indent = "yes"
    /> 

  <xsl:include href="params.xsl"/>

  <xsl:template match="/weblog">
    <page>
      <xhtml>
        <div class="weblog">
          <h1><xsl:value-of select="$weblog.title"/></h1>
          <xsl:apply-templates select="entry"/>
        </div>
        <div>
          <br/><br/>
          <p><b><a href="{$weblog.archive.path}">View complete weblog archive</a></b></p>
        </div>
      </xhtml>
    </page>
  </xsl:template>
  
  <xsl:template match="entry">
    <div class="weblog_entry">
      <xsl:attribute name="id">
        <xsl:value-of select="date"/>
      </xsl:attribute>
      <div>
        <i><xsl:value-of select="date"/></i>
        <xsl:if test="time"><i> at <xsl:value-of select="time"/></i></xsl:if>
      </div>
      <xsl:call-template name="InsertTitle"/>
      <p>
        <xsl:apply-templates select="content"/>
        <a><xsl:attribute name="href"><xsl:value-of select="$weblog.archive.path"/>
            <xsl:text>/#</xsl:text><xsl:value-of select="date"/>
          </xsl:attribute>
          <xsl:text> #</xsl:text>
        </a>
      </p>
    </div>
  </xsl:template>
  
  <xsl:template name="InsertTitle">
    <xsl:if test="title">
      <h2>
        <xsl:choose>
          <xsl:when test="link">
            <a><xsl:attribute name="href"><xsl:value-of select="link"/></xsl:attribute>
              <xsl:value-of select="title"/>
            </a>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="title"/>
          </xsl:otherwise>
        </xsl:choose>
      </h2>
    </xsl:if>
  </xsl:template>
  
  <xsl:template match="content">
    <xsl:copy-of select="*|text()"/>
  </xsl:template>
  
</xsl:stylesheet>
