<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns="http://purl.org/rss/1.0/"
                xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
                xmlns:dc="http://purl.org/dc/elements/1.1/"
                >
<!--Copyright (c) 2002-2003 Simon Woodside - http://www.simonwoodside.com-->
<!--This is open source software under the terms in LICENSE.txt-->

<!-- convert from weblog XML dialect into RSS 1.0 format for syndication -->

  <xsl:strip-space elements="*"/>
  <xsl:output 
    method = "xml"
    indent = "yes"
    encoding = "UTF-8"
    /> 

  <xsl:include href="params.xsl"/>

  <xsl:template match="/weblog">
    <rdf:RDF>
      <channel>
        <title><xsl:value-of select="$weblog.title"/></title> 
        <link><xsl:value-of select="$weblog.link"/></link> 
        <description><xsl:value-of select="$weblog.description"/></description> 
        <language><xsl:value-of select="$weblog.language"/></language> 
        <copyright><xsl:value-of select="$weblog.copyright"/></copyright> 
        <webMaster><xsl:value-of select="$weblog.rss.webMaster"/></webMaster> 
      </channel>
        
      <xsl:apply-templates select="entry[$weblog.rss.plurality&gt;=position()]"/>
  
    </rdf:RDF>
  </xsl:template>

  <xsl:template match="entry">
    <item>
      <xsl:call-template name="InsertTitle"/>
      <link>
        <xsl:text>http://</xsl:text>
        <xsl:value-of select="$weblog.host"/>
        <xsl:value-of select="$weblog.path"/>
        <xsl:text>/#</xsl:text>
        <xsl:value-of select="date"/>
      </link>
      <dc:date><xsl:value-of select="translate(date, '/', '-')"/></dc:date>
      <description>
        <xsl:value-of select="substring(string(content), 1, 250)"/>
        <xsl:text> ...</xsl:text>
      </description>
    </item>
  </xsl:template>
  
  <xsl:template name="InsertTitle">
    <title>
      <xsl:choose>
        <xsl:when test="title">
          <xsl:value-of select="title"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>Quoth: </xsl:text>
          <xsl:value-of select="substring(string(content),1,50)"/>
          <xsl:text> ...</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </title>
  </xsl:template>

</xsl:stylesheet>
