<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<!--Copyright (c) 2002-2003 Simon Woodside - http://www.simonwoodside.com-->
<!--This is open source software under the terms in LICENSE.txt-->

<!-- all this really does is handle includes if needed, otherwise copy through -->
<!-- output from here requires further processing by blog2*.xsl -->

  <xsl:output 
    method = "xml"
    indent = "yes"
    /> 

  <xsl:include href="params.xsl"/>

  <xsl:template match="/weblog">
    <weblog>
      <xsl:choose>
        <xsl:when test="include">
          <xsl:call-template name="getFromInclude"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates select="entry"/>
        </xsl:otherwise>
      </xsl:choose>
    </weblog>
  </xsl:template>
  
  <xsl:template name="getFromInclude">
    <xsl:choose>
      <xsl:when test="include/plurality">
        <xsl:apply-templates 
          select="document($weblog.source_file,.)/weblog/entry[
            position() &lt;= current()/include/plurality  ]"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates select="document($weblog.source_file,.)/weblog/entry"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template match="@*|node()">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
  </xsl:template>

</xsl:stylesheet>
