<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<!--Copyright (c) 2002-2003 Simon Woodside - http://www.simonwoodside.com-->
<!--This is open source software under the terms in LICENSE.txt-->

<!-- converts a very simple internal page XML dialect into HTML good for 
     final output to the client UA in HTML format.
     Most of the work has already been done by this stage, we are just 
     wrapping it up with nice ribbons and bows, like adding the CSS2 links,
     the sidebars, notices, etc.
     We spawn additional AxKit pipelines for some things (e.g. the sitemenu)
     for modularity.
-->

  <xsl:output 
    method = "html"
    encoding = "utf-8"
    indent = "yes"
    media-type = "text/html" 
    doctype-public = "-//W3C//DTD HTML 4.01 Transitional//EN"
    doctype-system = "http://www.w3.org/TR/REC-html40/loose.dtd"
    /> 
    
  <xsl:include href="/xsl/params.xsl"/>
  
  <xsl:template match="/page">
    <html lang="en">
      <xsl:call-template name="headTemplate"/>
      <body>
        <div id="banner">
          <xsl:copy-of select="document('/xinc/banner.xml')"/>
        </div> <!--banner-->
        <div id="leftcontent">
          <xsl:copy-of select="document('axkit:/xinc/sitemenu.xml')"/>
        </div> <!--leftcontent-->
        <div id="centercontent">
          <xsl:apply-templates/>
        </div> <!--centercontent-->
        <div id="rightcontent">
          <br/>
          <p><b>Recent blog entries</b></p>
          <xsl:copy-of select="document('axkit:/weblog/front.xml')/page/xhtml/*"/>
          <p>[<a href="{$site.weblog.path}">more recent entries</a>]</p>
          <div id="notice">
            <xsl:copy-of select="document('//xinc/notice.xml')"/>
          </div>
        </div> <!--rightcontent-->
      </body>
    </html>
  </xsl:template>
    
  <xsl:template match="/page/title"/>
  
  <xsl:template match="/page/xhtml">
    <xsl:copy-of select="*"/>
  </xsl:template>
  
  <xsl:template name="headTemplate">
    <head>
      <title><xsl:value-of select="/page/title"/></title>
      <link rel="Stylesheet" type="text/css" media="all" href="/weblog/css/all.css"/>
      <link rel="Stylesheet" type="text/css" media="all">
        <xsl:attribute name="href">/css/style.css</xsl:attribute>
      </link>
      <meta name="description" content="{$site.description}"/>
    </head>
  </xsl:template>

</xsl:stylesheet>
