<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<!--Copyright (c) 2002-2003 Simon Woodside - http://www.simonwoodside.com-->
<!--This is open source software under the terms in LICENSE.txt-->

<!-- convert the xinc/sitemenu.xml file into XHTML for inclusion -->
  <xsl:output method = "xml"/> 
    
  <xsl:param name="bypass"/>
  <xsl:template match="/">
    <xsl:choose>
      <xsl:when test="$bypass = ''">
        <xsl:apply-templates/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:copy-of select="*|@*"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="menu">
    <div id="sitemenu">
      <ul>
        <xsl:apply-templates select="item"/>
      </ul>
   </div>
  </xsl:template>
  
  <xsl:template match="title">
    <p><b><xsl:value-of select="."/></b></p>
  </xsl:template>
  
  <xsl:template match="item">
      <li><a href="{@url}"><xsl:value-of select="."/></a></li>
  </xsl:template>
  
</xsl:stylesheet>
