// bottlenose.js

// This software is available under the following open source BSD license.
//
// Copyright (c) 2005 Simon Woodside
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
// 3. The name of the author may not be used to endorse or promote products
// derived from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

// Original source code by Simon Woodside <sbwoodside@yahoo.com>


// Important: Don't modify this file.
// But do read it, since it contains documentation for various 
// constants and how to use send_event() and also some useful
// utility functions.

// The javascript in this file implements the core communications 
// protocol between an asynchronous javascript / HTML UI and the 
// native view. You use the functions here (mainly send_event())
// to implement the widget portion of the UI in javascript.
// Normally you wouldn't change anything here, unless you really want
// to (and know what you're doing).



//
// Configuration directives
//

// kHost should be http://localhost and then some port number which must
// be the same number used by the Bottlenose Server.
var kHost = "http://localhost:31337/";



//
// Constants
//

// These are codes that are defined by Bottlenose for use in the 
// coordinating calls to the native view.
// These are kept in sync with the native bottlenose code.
// In new versions new codes will be added but never changed or removed.

// Event return values -
// These provide the basic information about the success or failure of
// an event call.
// This is the first thing to check in your callback functions.
var kBottleEventOK         =  1; // no error
var kBottleEventError      =  0; // unspecified error
var kBottleEventUnknown    = -1; // the eventID is not known by the server
var kBottleEventCancel     = -2; // the user cancelled the event
var kBottleEventOutOfRange = -3; // an index is out of range

// Response keys - 
// these are the keys for the response dictionary (hashmap) that are
// universally used in all Bottlenose apps.
var kBottleKeyResponseCode = "response_code"; // the key to access the return value


// The global request object
var req;


//
// Event functions
//

// send_event is the primary point of contact with the server. This method
// will dispatch an event message to the native view in the appropriate
// format. (Returns are dealt with separately in processReqChange())
// This function takes a variable number of arguments.
// The first argument should always be the ID of the event - a string
// that identifies the event uniquely and universally.
// Following that the arguments must come in pairs in the form key, value
// to form a "dictionary" "hash table" or "parameter list" (the last is most accurate)
// Each key is a string, and the value is a string, a number, XML, whatever.
// You can have as many key/value combinations as you want.
// Example:   send_event("catch_things", "thing_type", "crawdads", "number", "10")
//     (tells your native view to catch 10 crawdads)
function send_event(eventID)
{
  // Construct basic request (with eventID - the event name)
  // .bottlereq is the magic extension for bottlenose event messages
  var request = kHost + kViewName + "/" + eventID + ".bottlereq?";
  // There has to be an odd number of arguments
  if( arguments.length % 2 != 1 ) { show_error("Error: send_event must have an ODD number of arguments!"); return; }
  // Construct the argument list in the form key=value with key/value pairs 
  // concatenated by & ampersands
  for( var i=1; i<arguments.length; i+=2 ) {
    request += arguments[i] + "=" + arguments[i+1];
    if( i < arguments.length-2 )
      request += "&";
  }
  loadXMLDoc(request);
}


//
// Event Utilities
//

// get_value provides a simple way to access values returned to your callbacks.
// Simply supply the response object as the first parameter and the key
// as the second parameter, and it will return the value for the key
// (or null if there is no value)
// TODO: throw an exception instead!
function get_value(r, k)
{
  var els = r.getElementsByTagName(k);
  if( els[0] == null ) {
    show_error( "get_value: attempt to access key " + k + " which does not exist!" );
    return null;
  }
  return els[0].firstChild.data;
}


//
// UI Utilities
//

// Useful for enabling and disabling (graying out) widgets by id
function enable_node(n)
{
  node = document.getElementById(n);
  node.removeAttribute("disabled");
}
function disable_node(n)
{
  node = document.getElementById(n);
  node.setAttribute("disabled", "1");
}



//
// XML RPC methods
//

// loadXMLDoc is the standard async javascript method of sending an
// asynchronous request to the server.
// There is no need to change this function, and you will never need to call
// it directly (call send_event instead)
function loadXMLDoc(url)
{
	req = false;
  // branch for native XMLHttpRequest object
  if(window.XMLHttpRequest) {
    try {
      req = new XMLHttpRequest();
      req.onreadystatechange = processReqChange;
      req.open("GET", url, true);
      req.send(null);
    } catch(e) {
      req = false;
      show_error(e);
    }
  } else {
    show_error("something wrong in loadXMLDoc...");
  }
}

// processReqChange is the standard async javascript method of receiving 
// responses to asynchronous requests.
// Bottlenose returns to us the original eventID. We then construct
// a javascript callback call using the eventID, and we pass in the
// XML dictionary format response information (in key/value pairs).
// All of your callback functions must be named "event_eventID(response)".
// Example:  for eventID of "catch_things"
//           make a function: function catch_things(response) {...}
// The response parameter will contain the XML response, which you can
// either manipulate directly, or, more easily, use get_value(r,k)
// to access the value for key k from response r.
// There is no need to change this function, and you will never call it
// directly (it gets called by the XMLHttpRequest machinery automatically)
function processReqChange()
{
  // only if req shows "loaded"
  if (req.readyState == 4) {
    // only if "OK"
    if (req.status == 200) {
      // get the response XML
      var resp  = req.responseXML.documentElement;
      // extract the eventID
      var eventID = resp.getElementsByTagName("eventID")[0].firstChild.data;
      // construct the name of the callback function
      var callback_str = "event_" + eventID;
      // this test doesn't work - fails in the compiler. Hmm.
      if( ! eval(callback_str) ) {
        show_error("ERROR callback " + callback_str + " doesn't exist!");
        return;
      }
      // now call the callback using eval
      eval( callback_str + "(resp)");
      // and that's all.
    }
    else {
      // we received a req.status other than 200
      // which means the server is telling us there was a server error
      show_error("There was a problem retrieving the XML data:\n" + req.statusText);
      return;
    }
  }
}


