// demo.js

// Javascript for the LiveVideoMixer demo
// Put anything here except for the callbacks, which go in demo-callbacks.js

// Edit this file to implement your HTML UI.

// kViewName MUST contain the name of the View Class that Bottlenose
// is displaying. This should match the setting in the .bottleview file.
var kViewName = "VideoMixView";

// Globals
var mPlaying = false; // true if the video is currently playing
var mCurrentCh = -1; // The channel currently being edited. -1 for no channel.
var kKeyChannel = "channel";


// This is called on the document load.
// Put all the initialization code here.
function init()
{
  mCurrentCh = -1;
  for( var i=0; i<3; i++ )
    unset_edit_channel(i);
  disable_node( "edit_channel0" );
  disable_node( "edit_channel1" );
  disable_node( "edit_channel2" );
  disable_node( "playbutton" );
  disable_node( "mask" );
  disable_node( "opacity" );
}


// Set a channel to be edited and update the UI to reflect that.
function set_edit_channel(ch)
{
  // make some visual indication of which channel is being edited
  var n = document.getElementById("ch" + ch + ".title");
  n.setAttribute("style", "color:red;");
  // enable a couple of widgets
  enable_node( "mask" );
  enable_node( "opacity" );
  // show a status message
  show_status("Now editing channel " + ch + "... drag the red box in the view to move or resize.");
}

// Unset a channel from being edited, and update the UI.
function unset_edit_channel(ch)
{
  // if the channel is -1 then skip it
  if( ch == -1 )
    return;
  // remove the red colour on the channel's "title"
  var n = document.getElementById("ch" + ch + ".title");
  n.setAttribute("style", "");
  // set the mask select to have nothing selected
  document.getElementById("mask").options[0].selected = true;
  // disable a couple of widgets
  disable_node( "mask" );
  disable_node( "opacity" );
}

function enable_channel(ch)
{
  // we need to give the user some indication that the channel now has a source
  // set on it ... so for now, add a * to the channel's "title"
  var n = document.getElementById( "ch" + ch + ".title" );
  n.replaceChild( document.createTextNode(ch + "*"), n.firstChild );
  
  // If this is the first channel with a source then we need to
  // enable some UI elements
  enable_node( "edit_channel" + ch );
  // now there is at least one video source, so enable the play button
  enable_node( "playbutton" );
  
  // show a status message
  show_status( "Source set for channel " + ch + ".");
}

function start_play()
{
  mPlaying = true;
  // set the play/stop button to show STOP (action if you click it now)
  document.getElementById("playbutton").setAttribute("value", "STOP");
  show_status("Playing.");  
}
function stop_play()
{
  mPlaying = false;
  // when playback is stopped, the currently edited channel also
  // is cleared in the native view (you can only edit while playing)
  unset_edit_channel(mCurrentCh);
  // remember no channel being edited now
  mCurrentCh = -1;
  // set the play/stop button to show PLAY (action if you click it now)
  document.getElementById("playbutton").setAttribute("value", "PLAY");
  show_status("Stopped.");
}


// This displays a status message in a textarea.
// Actually it prepends the message so you can get a running log.
function show_status(msg)
{
  var statbox = document.getElementById("statusbox");
  statbox.firstChild.insertData(0, msg + "\n");
  // scroll to the bottom
  statbox.scrollTop = 999;
  // was  statbox.replaceChild( document.createTextNode(msg), statbox.firstChild );
  statbox.removeAttribute("style");
}
// This displays an error message in the status textarea.
function show_error(err)
{
  show_status(err);
  var statbox = document.getElementById("statusbox");
  statbox.setAttribute("style", "color:red;");
}


