//
//  Colour.h
//  FractalTrees
//
//  Created by woodside on Sat Jun 01 2002.
//  Copyright (c) 2002 Simon Woodside. All rights reserved.
//

#import <AppKit/AppKit.h>

@class FractalView;

typedef enum {
    SWDefaultColourStyle = 0,
    SWGradientColourStyle = 1,
    SWSpectrumColourStyle = 2,
    SWMonochromeColourStyle = 3,
    SWDefaultCustomColourStyle = 4
} SWColourStyle;

@interface ColourController : NSObject 
{
    int height;
    
    // Outlets
    IBOutlet NSPopUpButton * colourStylePopUp;
    IBOutlet FractalView * view;
    IBOutlet NSSlider * alphaSlider;
    IBOutlet NSSlider * gradientSlider;
    
    // Colour Wells
    IBOutlet NSColorWell * gradientStartColourWell;
    IBOutlet NSColorWell * gradientEndColourWell;
    IBOutlet NSColorWell * monochromeColourWell;
    IBOutlet NSColorWell * backgroundColourWell;

}

// Public methods this class implements
- (void)setHeight:(int)d;
- (void)updateControlsDisabled;
- (NSColor *)getBackgroundColour;
- (NSColor *)getColourForLevel:(int)level withPosition:(float)pos;
@end
