//
//  Colour.m
//  FractalTrees
//
//  Created by woodside on Sat Jun 01 2002.
//  Copyright (c) 2002 Simon Woodside. All rights reserved.
//

#import "ColourController.h"
#import "FractalView.h"

#define SW_TOP_R 0.0
#define SW_TOP_G 0.7
#define SW_TOP_B 0.0
#define SW_BOT_R 0.5
#define SW_BOT_G 0.3
#define SW_BOT_B 0.15

#define SW_TOP_R_2 0.0
#define SW_TOP_G_2 0.633
#define SW_TOP_B_2 0.0
#define SW_BOT_R_2 0.324
#define SW_BOT_G_2 0.125
#define SW_BOT_B_2 0.0


@implementation ColourController

- (id)init
{
    [super init];
    height = 1;
    return self;
}


- (void)setHeight:(int)h
{
    height = h;
}

- (NSColor *)getBackgroundColour
{
    switch( [colourStylePopUp indexOfSelectedItem] )
    {
        case SWDefaultColourStyle:
            return [NSColor whiteColor];
            break;
        default:
            return [backgroundColourWell color];
    }
}

- (void)updateControlsDisabled
{
    [gradientStartColourWell setEnabled:YES];
    [gradientEndColourWell setEnabled:YES];
    [backgroundColourWell setEnabled:YES];
    [monochromeColourWell setEnabled:YES];
    switch( [colourStylePopUp indexOfSelectedItem] )
    {
        case SWDefaultColourStyle:
            [gradientStartColourWell setEnabled:NO];
            [gradientEndColourWell setEnabled:NO];
            [backgroundColourWell setEnabled:NO];
            [monochromeColourWell setEnabled:NO];
            break;
        case SWGradientColourStyle:
            [monochromeColourWell setEnabled:NO];
            break;
        case SWSpectrumColourStyle:
            [gradientStartColourWell setEnabled:NO];
            [gradientEndColourWell setEnabled:NO];
            [monochromeColourWell setEnabled:NO];
            break;
        case SWMonochromeColourStyle:
            [gradientStartColourWell setEnabled:NO];
            [gradientEndColourWell setEnabled:NO];
            break;
        case SWDefaultCustomColourStyle:
            [monochromeColourWell setEnabled:NO];
            break;
        default:
            NSBeep(); // shouldn't happen
    }
}

- (NSColor *)getColourForLevel:(int)level withPosition:(float)pos
{
    SWColourStyle colourStyle = [colourStylePopUp indexOfSelectedItem];
    float alpha = [alphaSlider floatValue];

    switch(colourStyle)
    {
        case SWDefaultColourStyle:
            // use the same colours as the next
        case SWDefaultCustomColourStyle:
            if( (1.0*level)/(height-1) > 0.8 ) //0.6 )
            {
                return [[gradientEndColourWell color] colorWithAlphaComponent:alpha];
            } else {
                return [[gradientStartColourWell color] colorWithAlphaComponent:alpha];
            }
            break;
        case SWMonochromeColourStyle:
            return [[monochromeColourWell color] colorWithAlphaComponent:alpha];
            break;
        case SWGradientColourStyle:
            if( [[gradientStartColourWell color]
                     blendedColorWithFraction:(level/height)
                                      ofColor:[gradientEndColourWell color]] )
            {
                return [[[gradientStartColourWell color]
                   blendedColorWithFraction:(1.0*level/(height))
                                    ofColor:[gradientEndColourWell color]]
                                        colorWithAlphaComponent:alpha];
            } else {
                return [NSColor redColor];
            }	// error
            break;
        case SWSpectrumColourStyle:
            return [NSColor colorWithCalibratedHue:
                fmod(pos + [gradientSlider floatValue], 1.0)
                                        saturation:1.0
                                        brightness:1.0
                                             alpha:alpha];
            break;
        default:
            // handle below
            break;
    }
    return [NSColor redColor];	// error
}

@end
