//
//  FractalController.h
//  FractalTrees
//
//  Created by woodside on Wed Jun 05 2002.
//  Copyright (c) 2002 Simon Woodside. All rights reserved.
//

#import <AppKit/AppKit.h>

@class ColourController, FractalView, FractalTreeGrower;

typedef enum {
    SWDepthField = 0,
    SWAngleDeltaField = 1,
    SWGrowthFactorField = 2,
    SWAngleRandomnessField = 3,
    SWLengthRandomnessField = 4,
    SWThicknessField = 5,
    SWZoomFactorField = 6,
} SWInformationField;

typedef enum {
    NotRandomStyle = 0,
    NaturalRandomStyle = 1,
    WildRandomStyle = 2,
    CrazyRandomStyle = 3,
    TooMuchRandomStyle = 4,
} RandomStyle;

#define SW_NATURAL_RANDOM_NUMBER 0.004
#define SW_WILD_RANDOM_NUMBER 0.0125
#define SW_CRAZY_RANDOM_NUMBER 0.025
#define SW_TOOMUCH_RANDOM_NUMBER 1.0

@interface FractalController : NSObject 
{
@public
    IBOutlet NSProgressIndicator * progressIndicator;
@protected
    // Instantiated fractal objects
    IBOutlet FractalView * view;
    IBOutlet ColourController * colour;
    IBOutlet FractalTreeGrower * grower;
    
    // Misc UI Elements
    IBOutlet NSTextField * depthField;
    IBOutlet NSStepper * heightStepper;
    
    // Buttons
    IBOutlet NSPopUpButton * colourStylePopUp;
    IBOutlet NSPopUpButton * randomStylePopUp;
    IBOutlet NSPopUpButton * drawStylePopUp;
    IBOutlet NSButton * growButton;
//    IBOutlet NSButton * randomButton;
    
    // Windows
    IBOutlet NSWindow * colourConfigureWindow;

    // Sliders
    IBOutlet NSSlider * lengthVarianceSlider;
    IBOutlet NSSlider * angleVarianceSlider;
    IBOutlet NSSlider * lengthSlider;
    IBOutlet NSSlider * angleSlider;
    IBOutlet NSSlider * widthSlider;
//    IBOutlet NSSlider * scaleSlider;
    
    // Stored for sliders
    float lengthSliderLast;
    float angleSliderLast;
    float widthSliderLast;
    int drawStylePopUpLast;
//    float scaleSliderLast;
    
    // Forms
    IBOutlet NSForm * informationForm;
    
    // State
    float lastColourValue;
    BOOL heightAtMax;
}

// ACTIONS
// UI Settings
- (IBAction)growingUISettingsHaveChanged:(id)sender;
- (IBAction)drawingUISettingsHaveChanged:(id)sender;
- (IBAction)colourStyleHasChanged:(id)sender;

// Tree Growth
- (IBAction)growAndDrawTree:(id)sender;

// Data Export
- (IBAction)copy:(id)sender;
- (IBAction)export:(id)sender;

// Checks
- (BOOL)drawingStyleSettingsFromUIHaveReallyChanged;

// METHODS
// Miscellaneous
- (void)initStuff;
- (void)updateDrawingSettingsFromUI;
- (void)updateGrowingSettingsFromUI;
- (void)updateInformationPanel;

// API
- (int)getDrawStyle;
- (int)getMaxHeight;
- (int)getHeight;
- (void)setProgressIndicatorAnimate:(BOOL)set;

@end
