//
//  FractalController.m
//  FractalTrees
//
//  Created by woodside on Wed Jun 05 2002.
//  Copyright (c) 2002 Simon Woodside. All rights reserved.
//

#import "FractalController.h"

#import "FractalView.h"
#import "ColourController.h"
#import "FractalTreeGrower.h"


@implementation FractalController

// **************************************************************
// Init
//
- (id)init
{
    [super init];
    //probably can't touch the NIB from here :-(
    heightAtMax = NO;
    return self;
}



// **************************************************************
// Actions (Changers)
//
- (IBAction)drawingUISettingsHaveChanged:(id)sender
{
    if( [self drawingStyleSettingsFromUIHaveReallyChanged] )
    {
        [self updateDrawingSettingsFromUI];
        [self updateInformationPanel];
        [view setAllowAutofit:YES];
        [self setProgressIndicatorAnimate:YES];
        [view setNeedsDisplay:YES];
  }
}
- (IBAction)growingUISettingsHaveChanged:(id)sender
{
    [self setProgressIndicatorAnimate:YES];
    [self updateGrowingSettingsFromUI];
    [self updateInformationPanel];
    [grower growTree];
    [view setAllowAutofit:YES];
    [view setNeedsDisplay:YES];
//    [self setProgressIndicatorAnimate:NO];
}
- (IBAction)colourStyleHasChanged:(id)sender;
{
    // stop double-draws
//    if( lastColourValue != [sender floatValue] )
    {
        lastColourValue = [sender floatValue]; // always defined? hmm...
        [self setProgressIndicatorAnimate:YES];
        [colour updateControlsDisabled];
        [self updateInformationPanel];
        [view setAllowAutofit:NO];
        [view setNeedsDisplay:YES];
//        [self setProgressIndicatorAnimate:NO];
    }
}


// **************************************************************
// Actions (Growers)
//
// should be renamed "new Tree"
- (void)initStuff;
{
    //I hope you're compiling this on 10.2 :-)
    if( NSAppKitVersionNumber > NSAppKitVersionNumber10_1 )
    {
        [progressIndicator setStyle:NSProgressIndicatorSpinningStyle];
        [progressIndicator setDisplayedWhenStopped:NO];
    }
    [progressIndicator setUsesThreadedAnimation:YES];
    [progressIndicator startAnimation:self];
    [progressIndicator stopAnimation:self];
    printf("controller: Initialized!\n");
}
- (IBAction)growAndDrawTree:(id)sender
{
    [self setProgressIndicatorAnimate:YES];
    [self updateGrowingSettingsFromUI];//because they don't all call in
    [grower newTree]; //growTree];
    [view setAllowAutofit:YES];
    [view setNeedsDisplay:YES];
//    [self setProgressIndicatorAnimate:NO];
    // view unsets setProgressIndicatorAnimate
}



// **************************************************************
// Data export
//
- (IBAction)copy:(id)sender;
{
    [view copy];
}
- (IBAction)export:(id)sender;
{
    [view export];
}


// **************************************************************
// Verifiers
//
- (BOOL)drawingStyleSettingsFromUIHaveReallyChanged;
{
    // the ui will say they "changed" even if the user
    // just clicks or lets go. this checks the values
    // Also checks the view, if it aborted the alst draw
    // for an event we must send it another one or else
    // it will stop in mid-draw and look bad
    if( lengthSliderLast != [lengthSlider floatValue] ||
        angleSliderLast != [angleSlider floatValue] ||
        widthSliderLast != [widthSlider floatValue] ||
        drawStylePopUpLast != [drawStylePopUp indexOfSelectedItem] ||
        [view abortedLastDrawForNewEvent] ) // trumps all
    { return YES; }
    else { return NO; }
}



// **************************************************************
// Updaters
//
- (void)updateDrawingSettingsFromUI;
{
    [view setLengthFactor:lengthSlider];
    [view setAngleTerm:angleSlider];
    [view setWidthFactor:widthSlider];
    // don't set updateStyle ... view asks for it
    lengthSliderLast = [lengthSlider floatValue];
    angleSliderLast =  [angleSlider floatValue];
    widthSliderLast =  [widthSlider floatValue];
    drawStylePopUpLast = [drawStylePopUp indexOfSelectedItem];

}
- (void)updateGrowingSettingsFromUI
{
    BOOL useRandom;

    if( heightAtMax == YES ) { NSBeep(); }
    if( [heightStepper intValue] == [heightStepper maxValue] )
    {
        heightAtMax = YES;
    } else {
        heightAtMax = NO;
    }
    // Depth
    // the stepper holds the reference value for depth
    [depthField setIntValue:[heightStepper intValue]];
    [colour setHeight:[heightStepper intValue]];
//    [grower setHeight:[heightStepper intValue]];

    // useRandom
    if( [randomStylePopUp indexOfSelectedItem] == NotRandomStyle )
    {	useRandom = NO;	}
    else
    {	useRandom = YES;	}
    switch( [randomStylePopUp indexOfSelectedItem] )
    {
        case NaturalRandomStyle:
            [lengthVarianceSlider setFloatValue:SW_NATURAL_RANDOM_NUMBER];
            [angleVarianceSlider setFloatValue:SW_NATURAL_RANDOM_NUMBER];
            break;
        case WildRandomStyle:
            [lengthVarianceSlider setFloatValue:SW_WILD_RANDOM_NUMBER];
            [angleVarianceSlider setFloatValue:SW_WILD_RANDOM_NUMBER];
            break;
        case CrazyRandomStyle:
            [lengthVarianceSlider setFloatValue:SW_CRAZY_RANDOM_NUMBER];
            [angleVarianceSlider setFloatValue:SW_CRAZY_RANDOM_NUMBER];
            break;
        case TooMuchRandomStyle:
            [lengthVarianceSlider setFloatValue:SW_TOOMUCH_RANDOM_NUMBER];
            [angleVarianceSlider setFloatValue:SW_TOOMUCH_RANDOM_NUMBER];
            break;
        case NotRandomStyle:
            break;
        default:
            NSBeep();
    }
    [grower setLengthVariance:[lengthVarianceSlider floatValue]];
    [grower setAngleVariance:[angleVarianceSlider floatValue]];
    [lengthVarianceSlider setEnabled:useRandom];
    [angleVarianceSlider setEnabled:useRandom];
    [grower setUseRandomness:useRandom];
}
- (void)updateInformationPanel
{
    [[informationForm cellAtIndex:SWDepthField]
            setIntValue:[heightStepper intValue]];
    [[informationForm cellAtIndex:SWAngleDeltaField]
            setFloatValue:[angleSlider floatValue]];
    [[informationForm cellAtIndex:SWGrowthFactorField]
            setFloatValue:[lengthSlider floatValue]];
    [[informationForm cellAtIndex:SWAngleRandomnessField]
            setFloatValue:[angleVarianceSlider floatValue]];
    [[informationForm cellAtIndex:SWLengthRandomnessField]
            setFloatValue:[lengthVarianceSlider floatValue]];
    [[informationForm cellAtIndex:SWThicknessField]
            setFloatValue:[widthSlider floatValue]];
}

// API
- (int)getDrawStyle;
{
    return [drawStylePopUp indexOfSelectedItem];
}
- (int)getMaxHeight;
{
    return [heightStepper maxValue];
}
- (int)getHeight;
{
    return [heightStepper intValue];
}
- (void)setProgressIndicatorAnimate:(BOOL)set;
{
    if( set) { [progressIndicator startAnimation:self]; }
    else { [progressIndicator stopAnimation:self]; }
}


@end
