//
//  FractalTreeBranch.h
//  FractalTrees
//
//  Created by woodside on Tue Apr 30 2002.
//  Copyright (c) 2002 Simon Woodside. All rights reserved.
//

#import <Foundation/Foundation.h>


@interface FractalTreeBranch : NSObject 
{
@public
    NSPoint 	curBase;
    NSPoint	curEnd;
    float	length;		// Relative length to 1 abstract "branch length unit"
    float 	angle;		// In radians
    float	curLength;
    float	curAngle;
    float	curPosition;	// 0 is the leftmost branch, 1 is the rightmost branch
    FractalTreeBranch * left;
    FractalTreeBranch * right;
}
- (void)setLengthAndAngle:(float)newLength angle:(float)newAngle;
- (void)setCurLength:(float)newLength curAngle:(float)newAngle;
- (void)setCurBase:(NSPoint)newBase;
- (void)setCurEnd:(NSPoint)newEnd;
- (void)setCurLength:(float)newLength
            curAngle:(float)newAngle
         curPosition:(float)newPosition
             curBase:(NSPoint)newBase;
- (void)setPositionForIndex:(int)index maxLevel:(int)level;
- (NSRect)normalizedRect;
@end
