//
//  FractalTreeBranch.m
//  FractalTrees
//
//  Created by woodside on Tue Apr 30 2002.
//  Copyright (c) 2002 Simon Woodside. All rights reserved.
//

#import "FractalTreeBranch.h"


@implementation FractalTreeBranch

/// hmmmm....
NSRect SWMakeNormalizedNonEmptyRect( NSRect rect )
{
    // no negative sizes
    if( rect.size.width < 0 )
    {
        rect.origin.x += 	rect.size.width;		// subtracts actually
        rect.size.width -= 	2.0 * rect.size.width;		// flips the sign
    }
    if( rect.size.height < 0 )
    {
        rect.origin.y += 	rect.size.height;
        rect.size.height -= 	2.0 * rect.size.height;
    }
    if( rect.size.width == 0 ) { rect.size.width = 0.1; }	// not quite empty
    if( rect.size.height == 0 ) { rect.size.height = 0.1; }
    return rect;
}


- (id)init
{
    [super init];
    length = 1.0;
    angle = 0.0;
    
    return self;
}

- (void)setLengthAndAngle:(float)newLength angle:(float)newAngle
{
    length = 	newLength;
    angle = 	newAngle;
}

- (void)setCurLength:(float)newLength curAngle:(float)newAngle;
{
    curLength = newLength;
    curAngle = newAngle;
}

- (void)setCurBase:(NSPoint)newBase;
{
    curBase = newBase;
}
    
- (void)setCurEnd:(NSPoint)newEnd;
{
    curEnd = newEnd;
}

- (void)setCurLength:(float)newLength
            curAngle:(float)newAngle
         curPosition:(float)newPosition
             curBase:(NSPoint)newBase;
//            curEnd:(NSPoint)newEnd;
{
    curLength = newLength;
    curAngle = newAngle;
    curPosition = newPosition;
    curBase = newBase;
//    curEnd = newEnd;
}

- (void)setPositionForIndex:(int)index maxLevel:(int)level;
{
    curPosition = index/pow(2,level);
}

- (NSRect)normalizedRect;
{
    NSRect result;
    result = SWMakeNormalizedNonEmptyRect(NSMakeRect( 
                                                    curBase.x, 
                                                    curBase.y, 
                                                    curEnd.x - curBase.x, 
                                                    curEnd.y - curBase.y
                                                    ));
    return result;
}

@end
