//
//  FractalTreeGrower.h
//  FractalTrees
//
//  Created by woodside on Tue Apr 30 2002.
//  Copyright (c) 2002 Simon Woodside. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "RandSupply.h"

@class FractalTreeBranch;
@class RandSupply;
@class FractalView;

@interface FractalTreeGrower : NSObject {
    IBOutlet FractalController * controller;

    float lengthFactor; 
    float angleTerm;
    float lengthVariance; 
    float angleVariance;
    FractalTreeBranch * root;	// GET RID OF THIS ***
    NSMutableArray * 	tree;
    RandSupply *	rand;

    // State
    BOOL useRandomness;
    BOOL needToGrow;
    int  maxHeight;
    BOOL haveInitialized;
}

// PUBLIC
// Misc
- (id)init;

// Grow
- (void)newTree;
- (void)growTree;
- (void)recursivelyGrowTree:	(FractalTreeBranch *)foo
                        length:	(float)length 
                        angle:	(float)angle
                        level:	(int)level;

// API
- (void)setUseRandomness:(BOOL)useRandom;
- (NSMutableArray *)tree;
- (void)setLengthVariance:(float)variance;
- (void)setAngleVariance:(float)variance;

@end
