//
//  FractalTreeGrower.m
//  FractalTrees
//
//  Created by woodside on Tue Apr 30 2002.
//  Copyright (c) 2002 Simon Woodside. All rights reserved.
//

#import "FractalView.h"
#import "FractalTreeGrower.h"
#import "FractalTreeBranch.h"
#import "FractalController.h"
#import "RandSupply.h"



@implementation FractalTreeGrower

- (id)init
{
    [super init];
    rand = [[RandSupply alloc] init];
    needToGrow = YES;
    return self;
}

- (void)newTree;
{
    needToGrow = YES;
    [self growTree];
}

- (void)growTree
{
    int i;

    if( !haveInitialized )
    {
        maxHeight = [controller getMaxHeight];
        haveInitialized = YES;
    }
    
    if( needToGrow )
    {
        root = [[FractalTreeBranch alloc] init];
        [tree autorelease]; // little bit of mem management :)
        tree = [[NSMutableArray alloc] initWithCapacity:maxHeight];
        
        // initialize the tree arrays to the right size
        for( i=0; i<=maxHeight; i++ )
        { [tree addObject:[NSMutableArray arrayWithCapacity:pow(2,i)]]; }
        
        [self recursivelyGrowTree:root length:1 angle:0 level:0];
        needToGrow = NO;
    }
}

// This function only does "real" work if it's a random tree
// otherwise it just generates a bunch of 1's and 0's
// - the rand calls are relatively slow
- (void)recursivelyGrowTree:(FractalTreeBranch *)subTree
                     length:(float)length angle:(float)angle level:(int)level
{
    float newLengthLeft, newLengthRight, newAngleLeft, newAngleRight;

    // Current branch
    [subTree setLengthAndAngle:length angle:angle];
    [[tree objectAtIndex:level] addObject:subTree];
    
    // Recurse
    if (level < maxHeight) //height)
    {
        level++; // for recursive call
        subTree->left =  [[FractalTreeBranch alloc] init];
        subTree->right = [[FractalTreeBranch alloc] init];
        if( useRandomness )
        {
            newLengthLeft =  [rand getNormalFloatWithMean:1 variance:lengthVariance];
            newLengthRight = [rand getNormalFloatWithMean:1 variance:lengthVariance];
            newAngleLeft =   [rand getNormalFloatWithMean:0 variance:angleVariance];
            newAngleRight =  [rand getNormalFloatWithMean:0 variance:angleVariance];
        } else {
            newLengthLeft = 1.0; newLengthRight = 1.0;
            newAngleLeft = 0.0; newAngleRight = 0.0;
        }
        [self recursivelyGrowTree:subTree->left  length:newLengthLeft  angle:newAngleLeft  level:level];
        [self recursivelyGrowTree:subTree->right length:newLengthRight angle:newAngleRight level:level];
    }
}


//
//
// API
//
//
- (void)setUseRandomness:(BOOL)useRandom
{
    useRandomness = useRandom;
}
- (void)setLengthVariance:(float)variance
{
    lengthVariance = variance;
}
- (void)setAngleVariance:(float)variance
{
    angleVariance = variance;
}
- (NSMutableArray *)tree;
{
    return tree;
}
@end
