//
//  FractalView.h
//  FractalTrees
//
//  Created by Simon Woodside on Thurs May 30 2002.
//  Copyright (c) 2002 Simon Woodside. All rights reserved.
//

#import <AppKit/AppKit.h>

@class FractalTreeBranch, FractalTreeGrower, ColourController, FractalController, RandSupply;

typedef enum {
    Never = 0,
    EveryBranch = 1,
    EveryLevel = 2,
    Timed = 3
} DrawFlushFrequency;

@interface FractalView : NSView
{
    // Controllers
    IBOutlet FractalController * 	controller;
    IBOutlet ColourController * 	colour;
    
    // Tree
    IBOutlet FractalTreeGrower * 	grower;
    
    // Display
    DrawFlushFrequency 	drawFlushFreq;
    float		widthFactor;
    float 		baseLength;
    float 		lengthFactor;
    float 		angleTerm;
    NSPoint 		basePoint;
    NSRect		newBounds;
    float		aspectRatio;
    NSPoint		mouseOriginInView;
    NSPoint		boundsOriginInView;
    NSCursor *		openGrabHandCursor;
    NSCursor *		closedGrabHandCursor;
    
    // State
    BOOL 		haveSetDefaults;
    BOOL		abortedDrawForNewEvent;
    NSDate * 		lastFlushDate;
    NSDate * 		lastAbortDate;
    BOOL		mouseIsDragging;
    BOOL		allowRecurse;
    BOOL		allowAutofit;
    BOOL                autofitNextTime;
    BOOL		reEnableAutofit;
    BOOL                lastDrawWasAborted;
    BOOL                recursing;
    BOOL                shouldDrawVisible;
    float		pixelSize;
}

// Gotta have it
- (id)initWithFrame:(NSRect)frame;

// Draw
- (void)drawRect:(NSRect)rect;
- (void)autofitBounds;
- (void)drawBranch:(FractalTreeBranch *)branch level:(int)level;
- (BOOL)shouldAutofitBounds;
- (BOOL)shouldAbortBecauseParametersChanged;
- (BOOL)shouldFlushGraphicsAfterBranch:(FractalTreeBranch *)branch;
- (void)initForFirstDraw;
- (void)resetForDraw;
- (void)linearDraw:(NSArray *)tree;

// Data export
- (void)copy;
- (void)export;
- (void)exportPanelDidEnd:(NSWindow *)sheet returnCode:(int)returnCode contextInfo:(void  *)contextInfo;

// Display methods
- (void)moveView:(NSPoint)mouseLocationInWindow;

// API
// general
- (void)setAllowAutofit:(BOOL)set;
- (void)setDrawFlushFrequency:(DrawFlushFrequency)freq;
- (void)setLengthFactor:(id)sender;
- (void)setAngleTerm:(id)sender;
- (void)setWidthFactor:(id)sender;
- (BOOL)abortedLastDrawForNewEvent;

@end
