//
// RandSupply.m
//
// This class is not copyrighted (Public Domain software)
// However, credit where it is due: originally by Eric Wu <htwunew@yahoo.com>
// It is provided AS IS without any kind of warranty included.
// Portions Copyright (c) 2002 Simon Woodside. All rights reserved.
//

#import "RandSupply.h"

@implementation RandSupply

-(id)init
{
    [super init];
    rn = fopen("/dev/urandom", "r");
    return self;
}

-(unsigned char) getRandomByte
{
    int l;
    l = fgetc(rn);
    return (unsigned char)l;
}

-(unsigned int)getRandomInt
{
    unsigned int a, b, c, d;
    a = fgetc(rn);
    b = fgetc(rn);
    c = fgetc(rn);
    d = fgetc(rn);
    return a+(b<<8)+(c<<16)+(d<<24);
}

-(unsigned int)getRandomIntLessThan:(unsigned int)i
{
    return [self getRandomInt] % i;
}

-(BOOL)getRandomBOOL
{
    return [self getRandomInt] % 2;
}

// random number between 0 and 1?
-(float)getRandomFloat
{
    unsigned int a=0;
    return ([self getRandomInt]+0.0) / (~a);
}

// 
// getNormalFloat
// Return a random value with a normal (gaussian) distribution.
// mean is 0 and variance is as given
// In practice the return value should in the range (-infinity, infinity)
//   but is actually in the range [-NUM_ITER, NUM_ITER].
//
// Use the "Central Limit Thorem Method". Jeruchim, et. al., recommend NUM_ITER >=20 for good results.
//   (Based on: http://www.dspguru.com/howto/tech/wgn2.htm by Matt Donadio <m.p.donadio@ieee.org>)
//
//
-(float)getNormalFloat
{
    float normal = 0.0;
    int i;
    int NUM_ITER = 10;
    
    for( i=0; i<NUM_ITER; i++ )
    {	normal = normal + [self getRandomFloat];	}

    // uniform randoms in [0,1] have mean 0.5 and variance of 1/12 (why???)
    // so adjust normal so that mean = 0 and variance = 1
    normal = normal - NUM_ITER/2;			// set mean to 0
    normal = normal * sqrt(12.0 / NUM_ITER);	// adjust variance to 1

    return normal;
}

//
// getNormalFloatWithVariance
// Return a random value with a normal (gaussian) distribution.
// mean is 0 and variance is as given
//
//
-(float)getNormalFloatWithVariance:(float)variance
{
    float normal;
    normal = [self getNormalFloat];
    normal = sqrt(variance) * normal;
    return normal;
}

//
// getNormalFloatWithMean: variance:
// Return a random value with a normal (gaussian) distribution.
// mean is as given and variance is as given
//
//
-(float)getNormalFloatWithMean:(float)mean variance:(float)variance
{
    float normal;
    normal = [self getNormalFloatWithVariance:variance];
    normal = mean + normal;
    return normal;
}

-(void)dealloc
{
     fclose(rn);
     [super dealloc];
}
@end
