#!/bin/sh

if [ $0 != "unpack21/unpack21.sh" ] ; then
  echo "must be run as unpack21/unpack21.sh"
  echo "current directory must contain S60_SDK_2_1_NET.zip"
  exit 1;
fi
echo "Unpacking the Nokia S60 2.1 SDK (for borland/microsoft.NET)"

mkdir unpack21_tmp

echo "Unzipping the SDK archive"
# Unpacking the Nokia S60 SDK...
unzip -d unpack21_tmp/tmp21/ S60_SDK_2_1_NET.zip
#note this didn't work for me.... I did it on OS X

echo "Extracting the CAB files..."
mkdir unpack21_tmp/data1_files
cabextract -q -dunpack21_tmp/data1_files "unpack21_tmp/tmp21/126 Series 60 v2.1 Final DOT NET 03.06.2004 0840/Data1.cab"
#i6comp cannot handle this version of the installer
#wine is unable to handle this version of the installer (setup.exe)
#possibly it might on someone else's system though

echo "Creating directory structure..."
mkdir target
cat unpack21/dirs.txt | xargs -n 1 mkdir

echo "Un-obfuscating file names and moving into place..."
cat unpack21/msname_realpath.txt | xargs -n 2 cp -n

echo "Unpacked SDK is in directory target"
echo "You may now delete directory unpack21_tmp"
echo "Done."
