<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
  version="1.0"
  xmlns:mid="http://simonwoodside.com/mid"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:exsl="http://exslt.org/common"
  extension-element-prefixes="exsl"
  >
  
  <xsl:output 
    method = "html"
    indent = "yes"
    /> 
  
  <!--**************************************************************-->
  <!--  Alexandra is copyright (C) 2002-3 Simon Woodside.
        Licensed under the GPL - see LICENSE for details -->
  <!--  mid2html
        Convert an intermediate forms dialect into HTML forms. -->
  <!--**************************************************************-->

  <xsl:variable name="formAction" select="string('')"/>
  <xsl:variable name="wholeInstPath" select="//mid:mid-start-at-inst"/>
  <xsl:variable name="divfake" select="'%'"/>
  <xsl:variable name="divreal" select="'/'"/>
  <xsl:variable name="breadcrumbsdivider" select="' &gt; '"/>

  <!--**************************************************************-->
  <!--  Output html headers, information about changes that were
        just made by the user, and then apply templates. -->
  <xsl:template match="mid:rngform">
    <xsl:variable name="breadcrumbs">
      <xsl:choose>
        <xsl:when test="mid:mid-start-at-inst">
          <xsl:call-template name="InsertBreadcrumbs_shim">
            <xsl:with-param name="fragment" select="mid:mid-start-at-inst"/>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>root</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <html>
      <head>
        <title>Alexandra — <xsl:value-of select="$breadcrumbs"/></title>
        <xsl:call-template name="css2"/>
      </head>
      <body>
        <div class="rngform">
          <h1>Alexandra — <xsl:value-of select="mid:subform-title"/></h1>
          <h2>Navigate</h2>
          <p>You are here: <xsl:copy-of select="$breadcrumbs"/></p>
          <xsl:if test="mid:add">
            <h2>You just added...</h2>
            <ul>
              <li>content: <xsl:value-of select="mid:add/mid:content"/></li>
              <li>with type: <xsl:value-of select="mid:add/mid:type"/></li>
              <li>at the location: <xsl:value-of select="mid:add/mid:into"/></li>
            </ul>
          </xsl:if>
          <h2>Change content</h2>
    
          <xsl:apply-templates/>
    
        </div>
      </body>
    </html>
  </xsl:template>
  <xsl:template match="mid:subform-title"/>
  
  <!--**************************************************************-->
  <!--  Debugging. -->
  <xsl:template match="mid:copyofsource">
    <div class="copyofsource">
      <xsl:text>Debuginfo: Copy of Source (RNG)</xsl:text><br/>
      <textarea name="copyofsource" style="width:100%" width="80" rows="40" wrap="virtual">
        <xsl:copy-of select="."/>
      </textarea>
    </div>
  </xsl:template>
  
  <xsl:template match="mid:add"/>
  
  
  <!--**************************************************************-->
  <!--**************************************************************-->
  <!--                                                              -->
  <!-- Templates to match RNG elements                              -->
  <!--                                                              -->
  <!--**************************************************************-->
  <!--**************************************************************-->

  <xsl:template match="mid:element">
    <div class="elementtitle">
      <xsl:call-template name="InsertPath"/>
    </div>
    <div class="elementarea">
      <xsl:apply-templates/>
    </div>
  </xsl:template>
  
  <xsl:template match="mid:optional">
    <div class="optionaltitle">
      <xsl:text>This is an optional part of </xsl:text>
      <xsl:value-of select="ancestor::mid:element[1]/mid:element-title/text()"/>
    </div>
    <div class="optionalarea">
      <xsl:apply-templates/>
    </div>
  </xsl:template>
  
  <xsl:template match="mid:oneormore">
    <div class="oneormoretitle">
      <xsl:text>One or More of the following are required</xsl:text>
    </div>
    <xsl:apply-templates/>
  </xsl:template>
  
  <xsl:template match="mid:zeroormore">
    <div class="zeroormoretitle">
      <xsl:text>Zero or more of the following are allowed</xsl:text>
    </div>
    <xsl:apply-templates/>
  </xsl:template>
  
  
  <!--**************************************************************-->
  <!--  Broken - doesn't allow choices to be made. -->
  <xsl:template match="mid:choices">
    <div class="choicestitle">
      <xsl:value-of select="mid:cardinality"/>
      <xsl:text> choices for </xsl:text>
      <xsl:value-of select="mid:choices-title"/>
    </div>
    <div class="choices">
      <xsl:apply-templates/>
    </div>
  </xsl:template>
  <xsl:template match="mid:choices-title"/>

  <!--**************************************************************-->
  <!--  Broken - doesn't allow a choice to be made. -->
  <xsl:template match="mid:choice">
    <div class="choicetitle">
      <xsl:text>This is a choice for </xsl:text>
      <xsl:choose>
        <xsl:when test="ancestor::mid:choices[1]/mid:choices-title/text()">
          <xsl:value-of select="ancestor::mid:choices[1]/mid:choices-title/text()"/>
        </xsl:when>
        <xsl:otherwise>BAR</xsl:otherwise>
      </xsl:choose>
    </div>
    <div class="choicearea">
<!--      <form action="form.html" method="GET">
        <input type="hidden"><xsl:attribute name="name">start_at_rng</xsl:attribute>
          <xsl:attribute name="value"><xsl:copy-of select="//mid:mid-start-at-rng"/></xsl:attribute>
        </input>
        <input type="hidden"><xsl:attribute name="name">add_xpath</xsl:attribute>
          <xsl:attribute name="value"><xsl:copy-of select="mid:add-info/mid:path"/></xsl:attribute>
        </input>
-->
        <xsl:apply-templates/>

<!--        <button type="submit">Choose this</button>
     </form>
-->    </div>
  </xsl:template>
    
  <!--**************************************************************-->
  <!--**************************************************************-->
  <!--                                                              -->
  <!-- Templates to generate user entry areas                       -->
  <!--                                                              -->
  <!--**************************************************************-->
  <!--**************************************************************-->

  <!--**************************************************************-->
  <!--  Where most textual additions or changes are made by the 
        user. -->
  <xsl:template match="mid:text-entry-area">
    <div class="form_textarea">
      <form action="{$formAction}" method="GET">
        <input type="hidden"><xsl:attribute name="name">start_at_rng</xsl:attribute>
          <!-- upon submit return to the same location -->
          <xsl:attribute name="value">
            <xsl:copy-of select="/mid:dummy/mid:rngform/mid:mid-start-at-rng"/>
          </xsl:attribute>
        </input>
        <input type="hidden"><xsl:attribute name="name">add_xpath</xsl:attribute>
          <xsl:attribute name="value"><xsl:copy-of select="mid:add-info/mid:path"/></xsl:attribute>
        </input>
        <input type="hidden"><xsl:attribute name="name">add_type</xsl:attribute>
          <xsl:attribute name="value"><xsl:copy-of select="mid:add-info/mid:type"/></xsl:attribute>
        </input>
        <xsl:call-template name="InsertInstanceExistsMessageIfNeeded"/>
        <textarea name="add_content" cols="50" rows="1">
          <xsl:value-of select="mid:instance-value"/>
        </textarea>
        <span class="form_description">
          <xsl:text> (</xsl:text><xsl:value-of select="mid:add-info/mid:type"/>
          <xsl:text>)</xsl:text>
        </span>
        <br/>
        <xsl:choose>
          <xsl:when test="mid:instance-value">
            <button type="submit">Change</button>
          </xsl:when>
          <xsl:otherwise>
            <button type="submit">+</button>
          </xsl:otherwise>
        </xsl:choose>
      </form>
    </div>
  </xsl:template>
  
  <!--**************************************************************-->
  <!--  Where users expand a truncated subtree of the RNG. -->
  <xsl:template match="mid:prune-point">
    <div class="form_prune_point">
      <xsl:call-template name="InsertInstanceExistsMessageIfNeeded"/>
      <div class="must_expand">
        <xsl:text>You must >>> expand this area to modify the contents</xsl:text>
      </div>
      <form action="{$formAction}" method="GET">
        <span class="form_prune_path">
          <xsl:value-of select="mid:new-inst-root"/>
        </span>
        <button type="submit" name="start_at_rng">
          <xsl:attribute name="value">
            <xsl:value-of select="mid:new-rng-root"/>
          </xsl:attribute>
          <xsl:text>>>></xsl:text>
        </button>
      </form>
    </div>
  </xsl:template>
  
  <!--**************************************************************-->
  <!--  Fill in the element's title. -->
  <xsl:template match="mid:element-title">
    <div class="sectiontitle">
      <xsl:value-of select="text()"/>
      <xsl:variable name="closestelement" select="ancestor::mid:element[2]"/>
      <xsl:choose>
        <xsl:when test="$closestelement//mid:optional//*[generate-id()=generate-id(current())]">
          <xsl:text> (optional in </xsl:text>
          <xsl:value-of select="$closestelement/mid:element-title/text()"/>
          <xsl:text>) </xsl:text>
        </xsl:when>
        <xsl:when test="$closestelement">
          <xsl:text> required in </xsl:text>
          <xsl:value-of select="$closestelement/mid:element-title/text()"/>
        </xsl:when>
      </xsl:choose>
    </div>
  </xsl:template>

  
  <xsl:template match="mid:title"/>
  <xsl:template match="mid:mid-start-at-rng"/>
  <xsl:template match="mid:mid-start-at-inst"/>
  <xsl:template match="mid:path"/>
  <xsl:template match="mid:instance-value"/>
  <xsl:template match="mid:add-info"/>
  <xsl:template match="mid:cardinality"/>

  <xsl:template match="title"/>
  <xsl:template match="value"/>
  

  <!--**************************************************************-->
  <!--**************************************************************-->
  <!--                                                              -->
  <!-- Named templates                                              -->
  <!--                                                              -->
  <!--**************************************************************-->
  <!--**************************************************************-->

  <!--**************************************************************-->
  <!--  Maybe not needed anymore. -->
  <xsl:template name="InsertPath">
    <xsl:choose>
      <xsl:when test="mid:path">
        <span class="path">
          <xsl:value-of select="mid:path"/>
        </span>
      </xsl:when>
      <xsl:otherwise>
        <span class="path">PATH NOT AVAILABLE</span>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
   
  <xsl:template name="InsertInstanceExistsMessageIfNeeded">
    <xsl:if test="mid:instance-value">
      <div class="instexists">
        <xsl:text>You have already filled a value. You may change it here.</xsl:text>
      </div>
    </xsl:if>
  </xsl:template>
  
  <!--**************************************************************-->
  <!--  Breadcrumbs are the hierarchical phrases at the top of the
        window that indicate where you are. These two named 
        templates create the breadcrumbs. You call the shim
        directly. -->
  <xsl:template name="InsertBreadcrumbs_shim">
    <xsl:param name="fragment"/>
    <xsl:variable name="argument" select="translate($fragment, $divreal, $divfake)"/>
    <xsl:call-template name="InsertBreadcrumbs">
      <xsl:with-param name="fragment" select="substring-after($argument, $divfake)"/>
      <xsl:with-param name="frag2"    select="substring-after($argument, $divfake)"/>
    </xsl:call-template>
  </xsl:template>
  
  <!--**************************************************************-->
  <!-- Never call this, call the shim -->
  <xsl:template name="InsertBreadcrumbs">
    <xsl:param name="fragment"/>
    <xsl:param name="frag2"/>
    <xsl:choose>
      <xsl:when test="contains($frag2, $divfake) and not(contains(substring-before($frag2, $divfake), $divreal))">
        <xsl:message>*** AAA</xsl:message>
        <a href="?">
          <xsl:value-of select="substring-before($fragment, $divfake)"/>
        </a>
        <xsl:value-of select="$breadcrumbsdivider"/>
      </xsl:when>
      <xsl:when test="contains($frag2, $divfake)">
        <a href="{$formAction}?start_at_inst=/{substring-before($frag2, $divfake)}">
          <xsl:value-of select="substring-before($fragment, $divfake)"/>
        </a>
        <xsl:value-of select="$breadcrumbsdivider"/>
      </xsl:when>
      <xsl:otherwise>
        <a href="{$formAction}?start_at_inst=/{$frag2}">
          <xsl:value-of select="$fragment"/>
        </a>
      </xsl:otherwise>
    </xsl:choose>
    <!-- output above / recursion below -->
    <xsl:if test="contains($fragment, $divfake)">
      <xsl:call-template name="InsertBreadcrumbs">
        <xsl:with-param name="fragment" select="substring-after($fragment, $divfake)"/>
        <xsl:with-param name="frag2">
          <xsl:value-of select="substring-before($frag2, $divfake)"/>
          <xsl:value-of select="$divreal"/>
          <xsl:value-of select="substring-after($frag2, $divfake)"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>
  
  <!--**************************************************************-->
  <!--  All the CSS2 stylesheet definitions go here. -->
  <xsl:template name="css2">
    <style>
      h1, h2 { font-family: sans-serif; }
      .sectiontitle { border: 1px solid black; display: table; margin: 1mm; 
                      font-family: sans-serif; }
      .optionaltitle { display:none; background: blue; color:white; }
<!--      .optionalarea { margin-left: 15mm; margin-bottom: 3mm; border-left: 3px solid black; border-bottom: 3px solid black }
-->     
      .elementtitle { margin-left: 10mm; background: darkslateblue; display: table; }
      .elementarea { margin-left: 10mm; margin-bottom: 5mm; border-left: 5px solid darkslateblue; 
                     border-bottom: 5px solid darkslateblue; display: table;  }
      .choicetitle { background: lime; }
      .choicearea { margin-left: 5mm; margin-bottom: 3mm; border-left: 5px double lime; 
                    border-bottom: 5px double lime; }
      .oneormoretitle { background: orange; }
      .zeroormoretitle { background: lime; }
      .choicestitle { background: lime; }
      .path { font-family: sans-serif; font-size: 0.75em; color: darkslateblue; }
      .instexists { background: deeppink; }
      .form_textarea { background: white; margin-left: 5mm; }
      .form_description { font-family: sans-serif; vertical-align: top; color: gray; }
      .form_prune_point { background: yellow; }
      .form_prune_path { font-family: sans-serif; }
    </style>
  </xsl:template>

</xsl:stylesheet>

