<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:mid="http://simonwoodside.com/mid"
  xmlns:dyn="http://exslt.org/dynamic"
  extension-element-prefixes="dyn"
  >
  
  <xsl:output 
    method = "xml"
    indent = "yes"
    encoding = "UTF-8"
    />
    
  <!--**************************************************************-->
  <!--  Alexandra is copyright (C) 2002-3 Simon Woodside.
        Licensed under the GPL - see LICENSE for details -->
  <!--  rng2mid
        Convert an RNG (Relax NG) schema into an intermediate forms
        dialect. -->
  <!--**************************************************************-->

  <xsl:param name="add_xpath"/>
  <xsl:param name="add_type"/>
  <xsl:param name="add_content"/>

  <xsl:variable name="instance-source" select="document('inst.xml')"/>
  
  <xsl:variable name="mid-start-at-rng" select="/grammar/rngsub-start-at-rng/text()"/>
  <xsl:variable name="mid-start-at-inst" select="/grammar/rngsub-start-at-inst/text()"/>
  
  <!--**************************************************************-->
  <!--  Output some useful data for the next pipeline stage and
        then apply templates and pass a copy of the source. -->
  <xsl:template match="grammar">
    <mid:dummy>
      <xsl:element name="mid:rngform">
        <mid:subform-title>RNG Form</mid:subform-title>
        <xsl:if test="$mid-start-at-rng">
          <mid:mid-start-at-rng>
            <xsl:value-of select="$mid-start-at-rng"/>
          </mid:mid-start-at-rng>
          <xsl:if test="$mid-start-at-inst != ''">
            <mid:mid-start-at-inst>
              <xsl:value-of select="$mid-start-at-inst"/>
            </mid:mid-start-at-inst>
          </xsl:if>
        </xsl:if>
        <xsl:if test="$add_xpath != ''">
          <mid:add>
            <mid:content><xsl:value-of select="$add_content"/></mid:content>
            <mid:type><xsl:value-of select="$add_type"/></mid:type>
            <mid:into><xsl:value-of select="$add_xpath"/></mid:into>
          </mid:add>
        </xsl:if>
        
        <xsl:apply-templates/>
        
        <mid:copyofsource>
          <xsl:apply-templates mode="copyofsource"/>
        </mid:copyofsource>
        
      </xsl:element> <!-- rngform -->
    </mid:dummy>
  </xsl:template>
  
  <xsl:template match="*|@*" mode="copyofsource">
      <xsl:copy-of select="."/>
  </xsl:template>
  <xsl:template match="rngsub-start-at-rng" mode="copyofsource"/>
  <xsl:template match="rngsub-start-at-inst" mode="copyofsource"/>
  
  
  <!--**************************************************************-->
  <!--  Match where the RNG tree was truncated for depth. -->
  <xsl:template match="rngsub_stopped">
   <mid:prune-point>
      <mid:new-rng-root> <xsl:value-of select="rng_path"/> </mid:new-rng-root>
      <mid:new-inst-root> <xsl:value-of select="inst_path"/> </mid:new-inst-root>
      <xsl:call-template name="InsertInstanceValue"/>
    </mid:prune-point>
  </xsl:template>
  
  <xsl:template match="rngsub-start-at-rng"/>
  <xsl:template match="rngsub-start-at-inst"/>
  <xsl:template match="define"/>
  
  <!--**************************************************************-->
  <!--**************************************************************-->
  <!--                                                              -->
  <!-- Templates to match RNG elements                              -->
  <!--                                                              -->
  <!--**************************************************************-->
  <!--**************************************************************-->

  <!--**************************************************************-->
  <!-- Basic RNG blocks                                             -->
  <!--**************************************************************-->
  
 <xsl:template match="element">
    <xsl:message>*** Matching element named <xsl:value-of select="@name"/></xsl:message>
    <mid:element>
      <mid:element-title><xsl:value-of select="@name"/></mid:element-title>
      <mid:path>
        <xsl:if test="not(text)">
          <xsl:call-template name="RNGPathToSelf"/>
        </xsl:if>
      </mid:path>
      <xsl:call-template name="SimplyRecurse"/>
    </mid:element>
  </xsl:template>

  <xsl:template match="attribute">
    <xsl:message>*** Matching attribute named <xsl:value-of select="@name"/></xsl:message>
    <mid:element>
      <mid:element-title><xsl:value-of select="@name"/></mid:element-title>
      <mid:path>
        <xsl:if test="not(text)">
          <xsl:call-template name="RNGPathToSelf"/>
        </xsl:if>
      </mid:path>
      <xsl:choose>
        <xsl:when test="not(./*) or ./empty"> <!-- sometimes has no children -->
          <xsl:call-template name="TextEntryArea"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="SimplyRecurse"/>
        </xsl:otherwise>
      </xsl:choose>
    </mid:element>
  </xsl:template>
  

  <!--**************************************************************-->
  <!-- Conditional RNG blocks                                       -->
  <!--**************************************************************-->

  <xsl:template match="choice">
    <xsl:message>*** Matching Choice</xsl:message>
    <mid:choices>
      <mid:choices-title>
        <xsl:choose>
          <xsl:when test="ancestor-or-self::*[@name][1]/@name">
            <xsl:value-of select="ancestor-or-self::*[@name][1]/@name"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="/grammar/rngsub-start-at-title/text()"/>
          </xsl:otherwise>
        </xsl:choose>
      </mid:choices-title>
      <mid:path>
        <xsl:call-template name="RNGPathToSelf"/>
      </mid:path>
      <mid:cardinality><xsl:value-of select="count(*)"/></mid:cardinality >
      <xsl:call-template name="SimplyRecurse"/>
    </mid:choices>
  </xsl:template>
  <xsl:template match="rngsub-start-at-title"/>
  
  <xsl:template match="value">
    <mid:value>
      <mid:path>
        <xsl:call-template name="RNGPathToSelf"/>
      </mid:path>
      <xsl:call-template name="SimplyRecurse"/>
    </mid:value>
  </xsl:template>

  <xsl:template match="optional">
    <!--will always have only one child-->
    <mid:optional>
      <mid:path>
        <xsl:call-template name="RNGPathToChild"/>
      </mid:path>
      <xsl:call-template name="SimplyRecurse"/>
    </mid:optional>
  </xsl:template>


  <!--**************************************************************-->
  <!-- Dynamic RNG blocks                                           -->
  <!--**************************************************************-->

  <xsl:template match="zeroOrMore">
    <mid:zeroormore>
      <xsl:call-template name="SimplyRecurse"/>
    </mid:zeroormore>
  </xsl:template>
  
  <xsl:template match="oneOrMore">
    <mid:oneormore>
      <xsl:call-template name="SimplyRecurse"/>
    </mid:oneormore>
  </xsl:template>
  
  
  <!--**************************************************************-->
  <!-- Terminating RNG blocks                                       -->
  <!--**************************************************************-->
  
  <xsl:template match="text">
    <xsl:call-template name="TextEntryArea"/>
  </xsl:template>
  
  <xsl:template match="data">
    <xsl:call-template name="TextEntryArea"/>
    <!--should check for param children-->
  </xsl:template>
  
  <!--TODO-->
  <xsl:template match="group"/>
  
  
  <!--**************************************************************-->
  <!--**************************************************************-->
  <!--                                                              -->
  <!-- Named templates                                              -->
  <!--                                                              -->
  <!--**************************************************************-->
  <!--**************************************************************-->
  
  <!--**************************************************************-->
  <!-- Templates to output RNG paths or names of RNG nodes          -->
  <!--**************************************************************-->

  <xsl:template name="RNGNameOfNearestParent">
    <xsl:text>&lt;</xsl:text>
    <xsl:value-of 
      select="ancestor-or-self::*
        [self::element or self::attribute][@name][1]/@name"/>
    <xsl:text>&gt;</xsl:text>
  </xsl:template>
  
  <xsl:template name="RNGPathToChild">
    <xsl:call-template name="RNGPathToSelf"/>
    <xsl:text>/</xsl:text>
    <xsl:value-of 
      select="descendant-or-self::*
        [self::element or self::attribute][@name][1]/@name"/>
  </xsl:template>
  
  <!--**************************************************************-->
  <!--  This is complex because it merges the rngsub_start_at path
        with the "local" path (the path within the subtree of the
        RNG that we get as the source) and there can be overlap -->
  <xsl:template name="RNGPathToSelf">
    <xsl:variable name="first_part_of_local" select="ancestor-or-self::*[@name][last()]/@name"/>
    <xsl:variable name="fpol_len" select="string-length($first_part_of_local)"/>
    <xsl:variable name="msai_len" select="string-length($mid-start-at-inst)"/>
    <xsl:variable name="last_part_of_start_at" 
        select="substring($mid-start-at-inst, $msai_len - $fpol_len +1)"/>
    <xsl:variable name="equality" select="$first_part_of_local = $last_part_of_start_at"/>
    <xsl:value-of select="$mid-start-at-inst"/>
    <xsl:if test="not($equality) and $first_part_of_local != ''">
      <xsl:text>/</xsl:text>
      <xsl:value-of select="$first_part_of_local"/>
    </xsl:if>
    <xsl:for-each select="ancestor-or-self::*[@name][position() != last()]">
      <xsl:text>/</xsl:text>
      <xsl:value-of select="@name"/>
    </xsl:for-each>
    <!--ancestor-or-self::*/@name is broke in the version of libXSLT i'm using-->
  </xsl:template>

 
  <!--**************************************************************-->
  <!-- Other named templates                                        -->
  <!--**************************************************************-->

  <!--**************************************************************-->
  <!--  A text entry area with the instance value if available. -->
  <xsl:template name="TextEntryArea">
    <xsl:element name="mid:text-entry-area">
      <mid:add-info>
        <mid:path>
          <xsl:call-template name="RNGPathToSelf"/>
        </mid:path>
        <mid:type>
          <xsl:choose>
            <xsl:when test="@type">
              <xsl:value-of select="@type"/>
            </xsl:when>
            <xsl:otherwise>text</xsl:otherwise>
          </xsl:choose>
        </mid:type>
      </mid:add-info>
      <xsl:call-template name="InsertInstanceValue"/>
    </xsl:element>
  </xsl:template>

  <!--**************************************************************-->
  <!--  Insert the instance document value for this path, if there
        is one. -->
  <xsl:template name="InsertInstanceValue">
    <xsl:variable name="inst-path-str">
      <xsl:call-template name="RNGPathToSelf"/>
    </xsl:variable>
    <xsl:message>/\/\/\ <xsl:value-of select="$inst-path-str"/></xsl:message>
    <xsl:variable name="rngsub-node-name"><xsl:value-of select="local-name()"/></xsl:variable>
    <xsl:variable name="rngsub-inst-path"><xsl:value-of select="inst_path/text()"/></xsl:variable>
    <!-- inside this loop, the context is the instance document -->
    <xsl:for-each select="$instance-source">
      <xsl:variable name="inst-nodes">
        <xsl:copy-of select="dyn:evaluate($inst-path-str)"/>
      </xsl:variable>
      <xsl:choose>
        <xsl:when test="not(dyn:evaluate($inst-path-str)/*) and $inst-nodes != ''">
          <mid:instance-value>
            <xsl:value-of select="$inst-nodes"/>
          </mid:instance-value>
        </xsl:when>
        <xsl:when test="$rngsub-node-name='rngsub_stopped' and dyn:evaluate($rngsub-inst-path)">
          <mid:instance-value>
            <xsl:value-of select="$inst-nodes"/>
          </mid:instance-value>
        </xsl:when>
      </xsl:choose>
    </xsl:for-each>
  </xsl:template>
    
  <xsl:template name="SimplyRecurse">
    <xsl:choose>
      <xsl:when test="local-name()='choice'">
        <xsl:apply-templates mode="choice"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template match="*|@*" mode="choice">
    <mid:choice>
      <xsl:apply-templates select="."/>
    </mid:choice>
  </xsl:template>

  <xsl:template match="*|@*" mode="COMMENTOUT">
    <xsl:message>CRAP</xsl:message>
  </xsl:template>

</xsl:stylesheet>

