<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
  version="1.0"
  xmlns:rng="http://relaxng.org/ns/structure/1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:str="http://exslt.org/strings"
  xmlns:dyn="http://exslt.org/dynamic"
  xmlns:exsl="http://exslt.org/common"
  extension-element-prefixes="dyn str exsl"
  >
<!--  <xsl:namespace-alias
    stylesheet-prefix = "rng"
    result-prefix = "#default" 
    />-->
  <xsl:strip-space elements="rng:grammar"/>
  <xsl:output 
    method = "xml"
    indent = "yes"
    encoding = "UTF-8"
    />
 
  <!--**************************************************************-->
  <!--  Alexandra is copyright (C) 2002-3 Simon Woodside.
        Licensed under the GPL - see LICENSE for details -->
  <!--  update
        Updates an instance document with a given content at a
        given XPath in the document. Simply copies through the 
        input tree. -->
  <!--**************************************************************-->
 <xsl:param name="add_xpath"/>
  <xsl:param name="add_type"/>
  <xsl:param name="add_content"/>
  
  <xsl:variable name="instance_doc" select="'inst.xml'"/>
  <xsl:variable name="divfake" select="'%'"/>
  <xsl:variable name="divreal" select="'/'"/>
  
  <!--**************************************************************-->
  <!--  root -->
  <xsl:template match="/">
    <exsl:document 
        href="{$instance_doc}" 
        method="xml" 
        indent="yes" 
        encoding="UTF-8">
      <xsl:if test="$add_content">
        <xsl:message>*** adding <xsl:copy-of select="$add_content"/></xsl:message>
        <xsl:apply-templates select="document(string($instance_doc))" mode="update"/>
      </xsl:if>
    </exsl:document>
    <xsl:apply-templates mode="change-namespace"/> 
  </xsl:template>
  
  <!--**************************************************************-->
  <!--  change the namespace (hack) -->
  <xsl:template match="rng:define" mode="change-namespace"/>
  <xsl:template match="*" mode="change-namespace">
    <xsl:element name="{local-name()}">
      <xsl:apply-templates select='@*' mode='change-namespace'/>
      <xsl:apply-templates select="* | text()" mode='change-namespace'/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="@*" mode="change-namespace">
    <xsl:copy-of select="."/>
  </xsl:template>


  <!--**************************************************************-->
  <!--  update -->
  <xsl:template match="*|@*" mode="update">
    <xsl:call-template name="OutputPaths_shim">
      <xsl:with-param name="fragment" select="$add_xpath"/>
    </xsl:call-template>
  </xsl:template>
  
  <xsl:template name="OutputPaths_shim" mode="update">
    <xsl:param name="fragment"/>
    <xsl:variable name="argument" select="translate($fragment, $divreal, $divfake)"/>
    <xsl:call-template name="OutputPaths">
      <xsl:with-param name="fragment" select="substring-after($argument, $divfake)"/>
      <xsl:with-param name="frag2" select="substring-after($argument, $divfake)"/>
    </xsl:call-template>
  </xsl:template>
  
  <xsl:template name="OutputPaths" mode="update">
    <xsl:param name="fragment"/>
    <xsl:param name="frag2"/>
    <xsl:variable name="testpath">
      <xsl:text>/</xsl:text>
      <xsl:choose>
        <xsl:when test="contains($frag2, $divfake)">
          <xsl:value-of select="substring-before($frag2, $divfake)"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$frag2"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="testpathfound">
      <xsl:choose>
        <xsl:when test="dyn:evaluate($testpath)">YES</xsl:when>
        <xsl:otherwise>NO</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:message>
      <xsl:text>*** </xsl:text>
      <xsl:value-of select="$testpath"/><xsl:text>, </xsl:text>
      <xsl:value-of select="$testpathfound"/><xsl:text>, fragment=</xsl:text>
      <xsl:value-of select="$fragment"/><xsl:text>, frag2=</xsl:text>
      <xsl:value-of select="$frag2"/><xsl:text></xsl:text>
    </xsl:message>
    <!-- processing above / recursion below -->
    <xsl:choose>
      <xsl:when test="$testpathfound = 'YES'">
        <xsl:apply-templates select="dyn:evaluate($testpath)" mode="locate_max_existing_xpath"/>
      </xsl:when>
    </xsl:choose>
    <xsl:choose>
      <xsl:when test="contains($fragment, $divfake)">
        <xsl:variable name="newstepname">
          <xsl:value-of select="substring-before($fragment, $divfake)"/>
        </xsl:variable>
        <xsl:variable name="followstepname">
          <xsl:choose>
            <xsl:when test="substring-before(substring-after($frag2, $divfake), $divfake)">
              <xsl:value-of 
                  select="substring-before(substring-after($frag2, $divfake), $divfake)"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="substring-after($frag2, $divfake)"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:message>*** newstepname=<xsl:value-of select="$newstepname"/>
          <xsl:text>  followstepname=</xsl:text><xsl:value-of select="$followstepname"/>
        </xsl:message>
        <xsl:element name="{$newstepname}">
          <xsl:call-template name="OutputPaths">
            <xsl:with-param name="fragment" select="substring-after($fragment, $divfake)"/>
            <xsl:with-param name="frag2">
              <xsl:value-of select="substring-before($frag2, $divfake)"/>
              <xsl:value-of select="$divreal"/>
              <xsl:value-of select="substring-after($frag2, $divfake)"/>
            </xsl:with-param>
          </xsl:call-template>
          <xsl:copy-of select="dyn:evaluate($testpath)/*[local-name() != $followstepname]"/>
        </xsl:element>
      </xsl:when>
      <xsl:otherwise>
        <xsl:variable name="newstepname">
          <xsl:value-of select="$fragment"/>
        </xsl:variable>
        <xsl:message>*** newstepname=<xsl:value-of select="$newstepname"/></xsl:message>
        <xsl:element name="{$newstepname}">
          <xsl:copy-of select="$add_content"/>
        </xsl:element>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="*|@*" mode="locate_max_existing_xpath"/>

</xsl:stylesheet>

